<?php
/*
Plugin Name: استخاره با قرآن کریم
Plugin URI : http://wp-master.ir
Author: wp-master.ir
Author URI: http://wp-master.ir
Description: estekhare
Version: 0.2
Text Domain: estekhare
 */

/*
 * No script kiddies please!
 */
defined('ABSPATH') or die("اللهم صل علی محمد و آل محمد و عجل فرجهم");

/*
 * Defines
 */
define('_estekhare_DIR', dirname(__FILE__) . DIRECTORY_SEPARATOR);
define('_estekhare_PATH', plugin_dir_url(__FILE__));

/*
 * load plugin language
 */
add_action('plugins_loaded', '_estekhare_lang');
function _estekhare_lang() {
	load_plugin_textdomain('estekhare', false, dirname(plugin_basename(__FILE__)) . DIRECTORY_SEPARATOR);
}
__('estekhare', 'estekhare');
__('estekhare', 'estekhare');

/**
 * Load Plugin Style And script that are need in front area
 */
function estekhare_user_styles_scripts($hook) {
	if (!is_admin()) {
		wp_register_script('estekhare' . 'user_JS', _estekhare_PATH . 'js/script.js', array('jquery'), 1.0, false);
		wp_register_style('estekhare' . 'user_CSS', _estekhare_PATH . 'css/style.css', array(), 1.0, 'all');
		/**
		 * Localizes Scripts
		 */
		$translation_array = array(
			'text' => __('Localizing was successful', 'estekhare'),
			'ajaxurl' => admin_url('admin-ajax.php'),
		);
		wp_localize_script('estekhare' . 'user_JS', 'estekhare', $translation_array);
		wp_enqueue_script('estekhare' . 'user_JS');
		wp_enqueue_style('estekhare' . 'user_CSS');

	} else {
		wp_register_script('estekhare' . 'admin_JS', _estekhare_PATH . 'js/admin.js', array('jquery'), 1.0, false);
		wp_register_style('estekhare' . 'admin_CSS', _estekhare_PATH . 'css/admin.css', array(), 1.0, 'all');
		wp_enqueue_script('estekhare' . 'admin_JS');
		wp_enqueue_style('estekhare' . 'admin_CSS');
	}

}

add_action('wp_enqueue_scripts', 'estekhare_user_styles_scripts');
add_action('admin_enqueue_scripts', 'estekhare_user_styles_scripts');

/**
 * On plugin activation
 */
function estekhare_activate() {

	// Activation code here...
}
register_activation_hook(__FILE__, 'estekhare_activate');

/**
 * On plugin deactivation
 */
function estekhare_deactivate() {

	// deactivation code here...
}
register_deactivation_hook(__FILE__, 'estekhare_deactivate');

/**
 * plugin shortcode
 */
function estekhare_shortcode() {
	$html = '<div id="estekhare">';
	$html .= '<img class="estekhare-header" src="' . _estekhare_PATH . '/css/img/estekhare-header.png">';
	$html .= '<img class="estekhare-get" src="' . _estekhare_PATH . '/css/img/estekhare-get.jpg"><div class="estekhare-ajax-wrapper"><img style="display:none;" class="estekhare-ajax" src="' . _estekhare_PATH . '/css/img/ajax-loader.gif"></div>';
	$html .= '<div id="estekhare-result"></div>';
	$html .= '</div> <!-- end of #estekhare --> ';
	return $html;
}
add_shortcode('estekhare', 'estekhare_shortcode');

/**
 * Ajax request handling
 */
add_action('wp_ajax_estekhareAction', 'estekhare_callback');
add_action('wp_ajax_nopriv_estekhareAction', 'estekhare_callback');
function estekhare_callback() {
	$estekhare = unserialize(file_get_contents(_estekhare_DIR . 'css' . DIRECTORY_SEPARATOR . 'img' . DIRECTORY_SEPARATOR . 'estekhare.dat'));
	$random = mt_rand(0, 301);
	$choice = $estekhare[$random];
	$choice['safhe'] = str_pad($choice['safhe'], 3, '0');
	$img_1 = _estekhare_PATH . 'css/img/ghoran/p' . ($choice['safhe']) . '.gif';
	$img_2 = _estekhare_PATH . 'css/img/ghoran/p' . (1 + (int) $choice['safhe']) . '.gif';
	$result = '<table cellspacing="1" cellpadding="1" border="0">
   <tbody>
      <tr>
         <td class="estekhare-tbl-title" align="left"  style="width: 101px" rowspan="1" colspan="1">نتیجه استخاره:&nbsp;&nbsp;</td>
         <td align="right">
            <span id="L_GoodBad_Name">' . $choice['natije'] . '</span>
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">نتیجه کلی:&nbsp;&nbsp;</td>
         <td align="right">
            <span id="L_Result_General">' . $choice['natije koli'] . '</span>
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">نتیجه ازدواج:&nbsp;&nbsp;</td>
         <td align="right">
            <span id="L_Result_Marriage">' . $choice['natije ezdevaj'] . '</span>
            &nbsp;
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">نتیجه معامله:&nbsp;&nbsp;
         </td>
         <td align="right">
            <span id="L_Result_Trade">' . $choice['natije moamele'] . '</span>
            &nbsp;
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">
            سوره:&nbsp;&nbsp;
         </td>
         <td align="right">
            <span id="L_Chapter_Name">' . $choice['soore'] . '</span>
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">آیه:&nbsp;&nbsp;
         </td>
         <td align="right">
            <span id="L_Ayeh">' . $choice['ayeh'] . '</span>
         </td>
      </tr>
      <tr>
         <td class="estekhare-tbl-title" align="left" style="width: 101px">صفحه:&nbsp;&nbsp;
         </td>
         <td align="right">
            ' . $choice['safhe'] . '
         </td>
      </tr>
   </tbody>
</table>
<table id="estekhare-ghoran-pages" cellspacing="0" cellpadding="0" bordercolor="#111111" border="0"  align="center" >
   <tbody>
      <tr>
         <td class="estekhare-half-width" valign="middle">
               <img class="gh-page-right" src="' . $img_1 . '">
         </td>
         <td class="estekhare-half-width" valign="middle">
              <img class="gh-page-left" src="' . $img_2 . '">
         </td>
      </tr>
   </tbody>
</table>';
	echo json_encode(array('ok' => 'yes', 'e' => $result));
	die();
}