<?php
/*
Plugin Name: Add to Any for IR
Description: Adds IRAN social networks to add to any plugin
Plugin URI: http://wp-master.ir
Author: Omid Shamloo
Author URI: http://wp-master.ir
Version: 1.1
License: GPL2
Text Domain: addtoanyextra
 */

/*

Copyright

----------
[1]
----------
Icons From:
http://ghalebgraph.ir/code-social-web-iran-wordl-page-offical.html
----------------------------------------------------------------------

 */

if (!defined('ABSPATH')) {
	exit;
}

add_action('plugins_loaded', array('add_to_any_extra_ir', 'get_instance'));

class add_to_any_extra_ir {

	private static $instance = null;
	private $plugin_url;

	public static function get_instance() {
		if (!isset(self::$instance)) {
			self::$instance = new self;
		}

		return self::$instance;
	}

	private function __construct() {
		$this->icons_url = plugin_dir_url(__FILE__) . '/icons/';

		add_filter('A2A_SHARE_SAVE_services', array($this, 'addtoany_add_services'), 10, 1);

		add_action('wp_head', array($this, 'css'));

	}

	function addtoany_add_services($services) {

		//http://www.cloob.com/share/link/add?url=Link&title=Title
		//http://facenama.com/links/?url=Link&title=Title
		//http://www.afsaran.ir/link/share?from=out&id=0&title=<-PostTitle->&url=<-PostLink->
		/**
		 * Example Of URL:
		 * 	https://www.example.com/share?url=A2A_LINKURL&title=A2A_LINKNAME
		 */

		$services['cloob_share_service'] = array(
			'name' => 'کلوب',
			'icon_url' => $this->icons_url . 'cloob.png',
			'icon_width' => 32,
			'icon_height' => 32,
			'href' => 'http://www.cloob.com/share/link/add?url=A2A_LINKURL&title=A2A_LINKNAME',
		);

		$services['facenama_share_service'] = array(
			'name' => 'فیس نما',
			'icon_url' => $this->icons_url . 'facenama.png',
			'icon_width' => 32,
			'icon_height' => 32,
			'href' => 'http://facenama.com/links/?url=A2A_LINKURL&title=A2A_LINKNAME',
		);

		$services['afsaran_share_service'] = array(
			'name' => 'افسران',
			'icon_url' => $this->icons_url . 'afsaran.png',
			'icon_width' => 32,
			'icon_height' => 32,
			'href' => 'http://www.afsaran.ir/link/share?from=out&id=0&title=A2A_LINKNAME&url=A2A_LINKURL',
		);
		return $services;
	}

	public function css() {
		$addtoany_options = get_option('addtoany_options', true);
		$real_size = 32;
		if (!empty($addtoany_options['icon_size'])) {
			$real_size = 32;
		}

		$custom_css = '
			.addtoany_share_save_container a > img {
				  width: ' . $real_size . 'px !important;
				  padding: 0 !important;
				  margin: 0 !important;


				}';
		echo '<style type="text/css">' . $custom_css . '</style>';
	}

}

