<?php
/*
Plugin Name: Zarinpal Gateway for GiveWP
Plugin URI: http://wp-master.ir/zarinpal-for-givewp
Version: 1.3.1
Author: Omid Shamloo
Author URI: http://wp-master.ir/
Text Domain: zarinpal-for-give
Description: Adds the Iranian zarinpal gateway for GiveWP
*/

class zarinpal_for_give
{

    function __construct()
    {
        /**
         * check parent plugin existance
         */
        if (!function_exists('give_is_test_mode')) {
            return;
        }

        /**
         * zarinpal Gateway does not need a CC form, so remove it.
         *
         * @return void
         * @since 1.0
         */
        add_action('give_zarinpal_cc_form', '__return_false');

        /**
         * Other actions & filters
         */
        add_filter('give_payment_gateways', array($this, 'zarinpal_for_give_register_payment_method'));
        add_filter('give_get_sections_gateways', array($this, 'zarinpal_for_give_register_payment_gateway_sections'));
        add_filter('give_get_settings_gateways', array($this, 'zarinpal_for_give_register_payment_gateway_setting_fields'));
        add_action('give_gateway_zarinpal', array($this, 'zarinpal_for_give_process_zarinpal_donation'));
        // add_action('init', array($this, 'give_process_zarinpal_return'));
        $this->give_process_zarinpal_return(); // like init action


    }
    /**
     * Register payment method.
     *
     * @param array $gateways List of registered gateways.
     *
     * @return array
     * @since 1.0.0
     *
     */

    // change the prefix zarinpal_for_give here to avoid collisions with other functions
    function zarinpal_for_give_register_payment_method($gateways)
    {

        // Duplicate this section to add support for multiple payment method from a custom payment gateway.
        $gateways['zarinpal'] = array(
            'admin_label' => __('زرین پال', 'zarinpal-for-give'), // This label will be displayed under Give settings in admin.
            'checkout_label' => __('زرین پال', 'zarinpal-for-give'), // This label will be displayed on donation form in frontend.
        );

        return $gateways;
    }

    /**
     * Register Section for Payment Gateway Settings.
     *
     * @param array $sections List of payment gateway sections.
     *
     * @return array
     * @since 1.0.0
     *
     */

    // change the zarinpal_for_give prefix to avoid collisions with other functions.
    function zarinpal_for_give_register_payment_gateway_sections($sections)
    {

        // `zarinpal-settings` is the name/slug of the payment gateway section.
        $sections['zarinpal-settings'] = __('زرین پال', 'zarinpal-for-give');

        return $sections;
    }



    /**
     * Register Admin Settings.
     *
     * @param array $settings List of admin settings.
     *
     * @return array
     * @since 1.0.0
     *
     */
// change the zarinpal_for_give prefix to avoid collisions with other functions.
    function zarinpal_for_give_register_payment_gateway_setting_fields($settings)
    {

        switch (give_get_current_setting_section()) {

            case 'zarinpal-settings':
                $settings = array(
                    array(
                        'id' => 'give_title_zarinpal',
                        'type' => 'title',
                    ),
                );

                $settings[] = array(
                    'name' => __('مرچنت', 'zarinpal-for-give'),
                    'desc' => __('مرچنت زرین پال را وارد کنید', 'zarinpal-for-give'),
                    'id' => 'zarinpal_for_give_merchantid',
                    'type' => 'text',
                );
                $settings[] = array(
                    'name' => __('فعال سازی زرین گیت', 'zarinpal-for-give'),
                    'desc' => __('آيا زرین گیت فعال شود؟ .', 'zarinpal-for-give'),
                    'id' => 'zarinpal_for_give_enable_zaringate',
                    'type' => 'checkbox',
                    'default' => '1',
                    'value' => '1',
                );
//                $settings[] = array(
//                    'name' => __('واحد  ریال و تومان ', 'zarinpal-for-give'),
//                    'desc' => __('آيا واحد ریال و تومان در پلاگین مادر فعال شود؟،قابل تنظیم در Donations >Settings>General>Currency ', 'zarinpal-for-give'),
//                    'id' => 'zarinpal_for_give_enable_IR_currency',
//                    'type' => 'checkbox',
//                    'default' => '1',
//                    'value' => '1',
//                );

                $settings[] = array(
                    'id' => 'give_title_zarinpal',
                    'type' => 'sectionend',
                );

                break;

        } // End switch().

        return $settings;
    }

    /**
     * Process Square checkout submission.
     *
     * @param array $posted_data List of posted data.
     *
     * @return void
     * @since  1.0.0
     * @access public
     *
     */

// change the zarinpal_for_give prefix to avoid collisions with other functions.
    function zarinpal_for_give_process_zarinpal_donation($posted_data)
    {

        if (give_is_test_mode()) {
            // Record Gateway Error as Pending Donation in Give is not created.
            give_record_gateway_error(
                __('test mode is enable', 'zarinpal-for-give'),
                sprintf(
                /* translators: %s Exception error message. */
                    __('zarinpal can noy work is test mode.', 'zarinpal-for-give')
                )
            );

            // Send user back to checkout.
            give_send_back_to_checkout('?payment-mode=zarinpal');
            return;
        }


        // Make sure we don't have any left over errors present.
        give_clear_errors();

        // Any errors?
        $errors = give_get_errors();

        // No errors, proceed.
        if (!$errors) {

            $form_id = intval($posted_data['post_data']['give-form-id']);
            $price_id = !empty($posted_data['post_data']['give-price-id']) ? $posted_data['post_data']['give-price-id'] : 0;
            $donation_amount = !empty($posted_data['price']) ? $posted_data['price'] : 0;

            // Setup the payment details.
            $donation_data = array(
                'price' => $donation_amount,
                'give_form_title' => $posted_data['post_data']['give-form-title'],
                'give_form_id' => $form_id,
                'give_price_id' => $price_id,
                'date' => $posted_data['date'],
                'user_email' => $posted_data['user_email'],
                'purchase_key' => $posted_data['purchase_key'],
                'currency' => give_get_currency($form_id),
                'user_info' => $posted_data['user_info'],
                'status' => 'pending',
                'gateway' => 'zarinpal',
            );

            // Record the pending donation.
            $donation_id = give_insert_payment($donation_data);

            if (!$donation_id) {

                // Record Gateway Error as Pending Donation in Give is not created.
                give_record_gateway_error(
                    __('zarinpal Error', 'zarinpal-for-give'),
                    sprintf(
                    /* translators: %s Exception error message. */
                        __('Unable to create a pending donation with Give.', 'zarinpal-for-give')
                    )
                );

                // Send user back to checkout.
                give_send_back_to_checkout('?payment-mode=zarinpal');
                return;
            }

            // Do the actual payment processing using the custom payment gateway API. To access the GiveWP settings, use give_get_option()
            // as a reference, this pulls the API key entered above: give_get_option('zarinpal_for_give_zarinpal_api_key')
            $MerchantID = give_get_option('zarinpal_for_give_merchantid'); //Required
            $Zaringate = (give_get_option('zarinpal_for_give_enable_zaringate') == 'on') ? true : false;
            $Amount = $donation_amount; //Amount will be based on Toman - Required
            $Description = 'پرداخت از GiveWP برای فرم ' . $posted_data['post_data']['give-form-title']; // Required
            $Email = !empty($posted_data['user_email']) ? $posted_data['user_email'] : ''; // Optional
            // $Mobile = '09123456789'; // Optional
            $CallbackURL = get_bloginfo('siteurl') . '/?zarinpal-for-give-return=true&payment_id=' . $donation_id; // Required

            $client = new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);

            $result = $client->PaymentRequest(
                [
                    'MerchantID' => $MerchantID,
                    'Amount' => $this->fix_amount($Amount,$form_id),
                    'Description' => $Description,
                    'Email' => $Email,
//                    'Mobile' => $Mobile,
                    'CallbackURL' => $CallbackURL,
                ]
            );

            //Redirect to URL You can do it also by creating a form
            if ($result->Status == 100) {
                $Redirect_url = 'https://www.zarinpal.com/pg/StartPay/' . $result->Authority;
                if ($Zaringate) {
                    $Redirect_url = $Redirect_url . '/ZarinGate';
                }

                Header('Location:' . $Redirect_url);
                //برای استفاده از زرین گیت باید ادرس به صورت زیر تغییر کند:
                //Header('Location: https://www.zarinpal.com/pg/StartPay/'.$result->Authority.'/ZarinGate');
            } else {
                // Record Gateway Error as Pending Donation in Give is not created.
                give_record_gateway_error(
                    __('zarinpal Error', 'zarinpal-for-give'),
                    sprintf(
                    /* translators: %s Exception error message. */
                        __('Unable to Connect to the Zarinpal[code:' . $result->Status . ']', 'zarinpal-for-give')
                    )
                );

                // Send user back to checkout.
                give_send_back_to_checkout('?payment-mode=zarinpal');
                return;

            }


        } else {

            // Send user back to checkout.
            give_send_back_to_checkout('?payment-mode=zarinpal');
        } // End if().
    }


    function give_process_zarinpal_return()
    {
        if (give_is_test_mode()) {
            return;
        }

        if (!isset($_GET['zarinpal-for-give-return'])) {
            return;
        }

        // Check the request method is POST.
        // if ( isset( $_SERVER['REQUEST_METHOD'] ) && 'POST' !== $_SERVER['REQUEST_METHOD'] ) {
        //     return;
        // }

        // if(!isset($_POST) || empty($_POST)){
        //     return;
        // }

        if (
            !isset($_GET['payment_id']) || empty($_GET['payment_id']) ||
            !isset($_GET['Authority']) || empty($_GET['Authority']) ||
            !isset($_GET['Status']) || empty($_GET['Status'])

        ) {
            return;
        }
        $payment_id = $_GET['payment_id'];

        // Must be a zarinpal gateway
        if ('zarinpal' !== give_get_payment_gateway($payment_id)) {
            return;
        }
        // Only complete payments once.
        if ( 'complete'  === get_post_status($payment_id) || 'failed' === get_post_status($payment_id)) {
            // already completed
            $this->redirect_to_failed_page();
            return;
        }


        $payment_meta = give_get_payment_meta($payment_id);
        $form_id = $payment_meta['form_id'];
        $payment_amount = give_donation_amount($payment_id);

        $MerchantID = give_get_option('zarinpal_for_give_merchantid'); //Required
        $Amount = $this->fix_amount($payment_amount,$form_id); //Amount will be based on Toman
        $Authority = sanitize_text_field($_GET['Authority']);

        if ($_GET['Status'] == 'OK') {

            $client = new SoapClient('https://www.zarinpal.com/pg/services/WebGate/wsdl', ['encoding' => 'UTF-8']);

            $result = $client->PaymentVerification(
                [
                    'MerchantID' => $MerchantID,
                    'Authority' => $Authority,
                    'Amount' => $Amount,
                ]
            );

            if ($result->Status == 100) {
                give_insert_payment_note($payment_id, __('Transaction success. RefID:' . $result->RefID, 'give'));
                give_set_payment_transaction_id($payment_id, $result->RefID);
                give_update_payment_status($payment_id, 'publish');
                $this->redirect_to_success_page();

            } else {
                give_update_payment_status($payment_id, 'failed');
                give_insert_payment_note($payment_id, __('Transaction failed. Status:' . $result->Status, 'give'));
                $this->redirect_to_failed_page();


            }
        } else {
            give_update_payment_status($payment_id, 'failed');
            give_insert_payment_note($payment_id, __('Transaction canceled by user', 'give'));
            $this->redirect_to_failed_page();

        }


        die();

    }

    function redirect_to_success_page()
    {
        wp_safe_redirect(give_get_success_page_uri());
        die();
    }

    function redirect_to_failed_page()
    {
        wp_safe_redirect(give_get_failed_transaction_uri());
        die();
    }

    function fix_amount($amount,$form_id,$gateway_default_currency='IRT') /* IRT | IRR */
    {
        $current_currency = give_get_currency($form_id);

        if(!in_array($current_currency,array('IRR','IRT')) || $current_currency==$gateway_default_currency || $amount <= 0 )
        {
          return $amount;
        }

        if($current_currency=='IRR')
        {

            return  $amount/10;
        }
        if($current_currency=='IRT')
        {

            return  $amount*10;
        }

        return $amount;

    }



}

add_action('init',function(){new zarinpal_for_give();});
// new zarinpal_for_give();


/**
 * Adds Iran Toman currency to your Give settings
 * it's required Give minimum Version 1.8.15
 * i dont know why this not working inside above class to comes here
 *
 * @param $currencies
 *
 * @return mixed
 * @since 1.8.15
 *
 */
function zarinpal_for_give_add_currency($currencies)
{
//    $enable_IR_currency = (give_get_option('zarinpal_for_give_enable_IR_currency') == 'on') ? true : false;
//    if($enable_IR_currency !='on')
//    {
//        return $currencies;
//    }
    $currencies['IRT'] = array(
        'admin_label' => __('تومان ایران', 'zarinpal-for-give'),
        'symbol' => __('تومان', 'zarinpal-for-give'),
        'setting' => array(
            'currency_position' => 'after',
            'thousands_separator' => '.',
            'decimal_separator' => ',',
            'number_decimals' => 0,
        ),
    );

    $currencies['IRR'] = array(
        'admin_label' => __('ریال ایران', 'zarinpal-for-give'),
        'symbol' => __('ریال', 'zarinpal-for-give'),
        'setting' => array(
            'currency_position' => 'after',
            'thousands_separator' => '.',
            'decimal_separator' => ',',
            'number_decimals' => 0,
        ),
    );


    return $currencies;
}

//add_filter('give_currencies', 'zarinpal_for_give_add_currency', 10, 1);

