<?php
/*
Plugin Name: No role for this site error fix
Plugin Version:4
Plugin URI: http://www.wp-master.ir/no-role-for-this-site-fix
Author: wp-master.ir
Author URI: http://www.wp-master.ir

*/

define('_wpmaster_change_bulk_user_meta_key', '_wpmaster_change_bulk_roles_changed');


add_action('wp_loaded', 'wpmaster_change_bulk_roles');
function wpmaster_change_bulk_roles()
{
    $meta_key = _wpmaster_change_bulk_user_meta_key;

    if(isset($_GET['no-role-for-this-site-fix-do-it-again']))
    {
        global $wpdb;
        $table = $wpdb->prefix.'usermeta';
        $res = $wpdb->delete ($table, array('meta_key' => $meta_key));
        @header('location:'.admin_url());
        die();
    }

    $role__not_in = array('administrator');
    $limit = 10;

    $args = array(

        'number' => $limit,
        'meta_key' => $meta_key,
        'meta_compare' => 'NOT EXISTS',

    );
    $users = get_users($args);
    $i = 0;
    if (count($users) > 0) {

        foreach ($users as $user) {
            $i++;
            $u = new WP_User($user->ID);
            $update_meta = 1;
            foreach ($role__not_in as $role) {
                if (in_array($role, (array)$u->roles)) {
                    $update_meta = false;
                }
            }
            if ($update_meta) {
                $user_roles = (array)$u->roles;
                $u->set_role(''); // remove all roles

                foreach ($user_roles as $role) {
                     $u->add_role($role);
                }
            }
            update_user_meta($user->ID, $meta_key, 1);


        }
    } else {
        if (is_admin() && current_user_can('manage_options')) {
            // die('salam,userha tabdil shodand , plugin disable shavad.');
            function wpmaster_bulk_role_meta_end_admin_notice()
            {
                global $pagenow;
                echo '<div class="notice notice-warning is-dismissible">
			             <p>'.__('The job of changing the role of users has been completed, please disable the plugin.','no-role-for-this-site-fix').'<a onclick="return confirm(\'Are you sure?\');" href="'.admin_url('/?no-role-for-this-site-fix-do-it-again=true').'">'.__('Do it again').'</a></p>
			         </div>';
            }

            add_action('admin_notices', 'wpmaster_bulk_role_meta_end_admin_notice');

        }
    }

    //Notice
    if (is_admin() && current_user_can('manage_options')) {
        function wpmaster_bulk_role_meta_count_admin_notice()
        {

            global $wpdb;
            $meta_count = $wpdb->get_var("select count(meta_key) as cnt from " . $wpdb->prefix . "usermeta where `meta_key`='" . _wpmaster_change_bulk_user_meta_key . "'");
            if ($meta_count) {
                echo '<div class="notice notice-warning is-dismissible">
				             <p>'.__('Number of roles that have been corrected so far:','no-role-for-this-site-fix').':' . $meta_count . '.</p>
				         </div>';
            }
        }


        add_action('admin_notices', 'wpmaster_bulk_role_meta_count_admin_notice');

    }


}




